@echo off
setlocal

echo Uninstalling Desk Shot...
echo.

:: Define the paths
set "STARTUP_DIR=%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup"
set "DESKTOP=%USERPROFILE%\Desktop"

:: Remove from Startup folder
echo Removing Desk Shot from Startup...
set "STARTUP_SHORTCUT=%STARTUP_DIR%\Desk Shot.lnk"

if exist "%STARTUP_SHORTCUT%" (
    del "%STARTUP_SHORTCUT%"
    if not exist "%STARTUP_SHORTCUT%" (
        echo Successfully removed from Startup.
    ) else (
        echo WARNING: Failed to remove from Startup.
    )
) else (
    echo Desk Shot was not found in Startup folder.
)

echo.

:: Remove Desktop shortcut
echo Removing Desktop shortcut...
set "DESKTOP_SHORTCUT=%DESKTOP%\Desk Shot.lnk"

if exist "%DESKTOP_SHORTCUT%" (
    del "%DESKTOP_SHORTCUT%"
    if not exist "%DESKTOP_SHORTCUT%" (
        echo Successfully removed Desktop shortcut.
    ) else (
        echo WARNING: Failed to remove Desktop shortcut.
    )
) else (
    echo Desktop shortcut was not found.
)

echo.

:: Check for any running instances of Desk Shot
echo Checking for running instances...
tasklist /FI "IMAGENAME eq Desk Shot.exe" 2>NUL | find /I /N "Desk Shot.exe">NUL
if "%ERRORLEVEL%"=="0" (
    echo.
    echo WARNING: Desk Shot is currently running.
    echo You may want to close it manually for a complete uninstallation.
    echo.
    choice /C YN /M "Do you want to terminate Desk Shot now"
    if errorlevel 2 goto :skip_terminate
    if errorlevel 1 (
        taskkill /F /IM "Desk Shot.exe" >NUL 2>&1
        if "%ERRORLEVEL%"=="0" (
            echo Desk Shot has been terminated.
        ) else (
            echo Failed to terminate Desk Shot. Please close it manually.
        )
    )
)

:skip_terminate
echo.
echo Uninstallation complete!
echo Desk Shot has been removed from Startup and Desktop shortcuts have been deleted.
echo.
echo Note: The application files remain in their current location.
echo You can manually delete the Desk Shot folder if you wish to completely remove the application.
echo.

pause